VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Object = "{852E65AD-72F8-11CF-840E-444553540000}#1.1#0"; "MIDIIO32.OCX"
Begin VB.Form frmMain 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "midi translator"
   ClientHeight    =   5280
   ClientLeft      =   3540
   ClientTop       =   3630
   ClientWidth     =   4890
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   8.25
      Charset         =   0
      Weight          =   700
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   ForeColor       =   &H80000008&
   Icon            =   "trans.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   5280
   ScaleWidth      =   4890
   Begin VB.CommandButton reverse 
      Caption         =   "reverse"
      Height          =   495
      Left            =   360
      TabIndex        =   12
      Top             =   2040
      Width           =   855
   End
   Begin VB.HScrollBar wheelnote 
      Height          =   255
      Left            =   360
      Max             =   127
      TabIndex        =   10
      Top             =   4560
      Value           =   64
      Width           =   3375
   End
   Begin VB.TextBox data2 
      Height          =   375
      Left            =   2520
      TabIndex        =   7
      Top             =   1560
      Width           =   1455
   End
   Begin VB.TextBox data1 
      Height          =   375
      Left            =   2520
      TabIndex        =   6
      Top             =   960
      Width           =   1455
   End
   Begin VB.TextBox message 
      Height          =   375
      Left            =   2520
      TabIndex        =   4
      Top             =   360
      Width           =   1455
   End
   Begin VB.CommandButton stopbutton 
      Caption         =   "stop"
      Height          =   615
      Left            =   360
      TabIndex        =   3
      Top             =   1200
      Width           =   855
   End
   Begin VB.VScrollBar vslidertranspose 
      Height          =   2295
      Left            =   1680
      Max             =   12
      TabIndex        =   1
      Top             =   360
      Width           =   255
   End
   Begin VB.CommandButton Command1 
      Caption         =   "go"
      Height          =   615
      Left            =   360
      TabIndex        =   0
      Top             =   360
      Width           =   855
   End
   Begin MidiioLib.MIDIOutput MIDIOutput1 
      Left            =   600
      Top             =   3240
      _Version        =   65537
      _ExtentX        =   847
      _ExtentY        =   847
      _StockProps     =   0
      DeviceID        =   0
      VolumeLeft      =   -1
      VolumeRight     =   -1
   End
   Begin MidiioLib.MIDIInput MIDIInput1 
      Left            =   120
      Top             =   3240
      _Version        =   65537
      _ExtentX        =   847
      _ExtentY        =   847
      _StockProps     =   0
      MessageEventEnable=   -1  'True
      MaxSysexSize    =   32000
   End
   Begin MSComDlg.CommonDialog CMDialog1 
      Left            =   1080
      Top             =   3240
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      DialogTitle     =   "System Exclusive Binary Files"
      Filter          =   "(*.syx) Sysex |*.syx|"
   End
   Begin VB.Label Label5 
      Caption         =   "wheelnote"
      Height          =   255
      Left            =   480
      TabIndex        =   11
      Top             =   4080
      Width           =   3375
   End
   Begin VB.Label Label4 
      Caption         =   "data2"
      Height          =   255
      Left            =   4200
      TabIndex        =   9
      Top             =   1560
      Width           =   495
   End
   Begin VB.Label Label3 
      Caption         =   "data1"
      Height          =   255
      Left            =   4200
      TabIndex        =   8
      Top             =   1080
      Width           =   615
   End
   Begin VB.Label Label2 
      Caption         =   "msg"
      Height          =   255
      Left            =   4200
      TabIndex        =   5
      Top             =   480
      Width           =   495
   End
   Begin VB.Label label1 
      Caption         =   "transpose"
      Height          =   255
      Left            =   1440
      TabIndex        =   2
      Top             =   2760
      Width           =   975
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuFileLoadBank 
         Caption         =   "&Load Bank"
      End
      Begin VB.Menu MnuSaveBankAs 
         Caption         =   "Save Bank &As..."
         Shortcut        =   ^A
      End
      Begin VB.Menu mnuFileSep1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFileExit 
         Caption         =   "E&xit"
      End
   End
   Begin VB.Menu mnuMidi 
      Caption         =   "&MIDI"
      Begin VB.Menu mnuMidiSetup 
         Caption         =   "&Setup"
      End
      Begin VB.Menu mnuMidiThru 
         Caption         =   "&Thru"
         Checked         =   -1  'True
      End
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "&Help"
      Begin VB.Menu mnuHelpAbout 
         Caption         =   "&About"
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' this is a working example taken from the Mabry midi io
' control download. it transposes incoming midi notes
' based on a slider value
'
' tz 10/26
'


Option Explicit

Dim DisplayBufferString(200) As String
Dim UserMessage As String
Dim firstopen As Boolean
Dim reversemode As Boolean




Private Sub Command1_Click()
'
' force user to open devices, first time
'
If firstopen = True Then
    Call mnuMidiSetup_Click
End If

'
' start the input & output streams
'
MIDIInput1.Action = MIDIIN_START
MIDIOutput1.Action = MIDIOUT_START
  
     
End Sub



Private Sub Form_Load()
    Dim I As Integer

' force device open first time
'
firstopen = True
reversemode = False




    ' Center the form on the screen
    Move (Screen.Width - Width) \ 2, (Screen.Height - Height) \ 2

End Sub

Private Sub Form_Unload(Cancel As Integer)
    ' Stop the MIDI In
    If (MIDIInput1.State <> 0) And (MIDIInput1.State <> 1) Then
        MIDIInput1.Action = MIDIIN_STOP
        End If
    
    ' Close MIDI In
    If (MIDIInput1.State <> 0) Then
        MIDIInput1.Action = MIDIIN_CLOSE
        End If
    
    ' Close MIDI Out
    MIDIOutput1.Action = MIDIOUT_CLOSE

    End
End Sub


Private Sub MIDIInput1_Error(ErrorCode As Integer, ErrorMessage As String)
    '
    ' Midi input error, display message
    '
   If (ErrorCode <> 0) And (ErrorCode <> 8) Then
      MsgBox ErrorMessage
      End If
End Sub



Private Sub MIDIOutput1_Error(ErrorCode As Integer, ErrorMessage As String)
    '
    ' Midi output error, display message
    '
   If (ErrorCode <> 0) And (ErrorCode <> 8) Then
      MsgBox ErrorMessage
      End If
End Sub


Private Sub mnuFileExit_Click()
    ' Stop the MIDI In
    MIDIInput1.Action = MIDIIN_STOP
    
    ' Close MIDI In
    MIDIInput1.Action = MIDIIN_CLOSE

    
    ' Close MIDI Out
    MIDIOutput1.Action = MIDIOUT_CLOSE

    End
End Sub

Private Sub mnuMidiSetup_Click()
  
    MIDISetupForm.Show MODAL
    firstopen = False
    
End Sub

Private Sub mnuMidiThru_Click()
    'Switch check mark on and off
    If mnuMidiThru.Checked = True Then
        mnuMidiThru.Checked = False
    Else
        mnuMidiThru.Checked = True
    End If
End Sub


' this is code to just
' do an echo thing

Sub MIDIInput1_Message()
   Dim InMessage As Integer
   Dim InData1 As Integer
   Dim InData2 As Integer
   Dim Y As Integer

     'This do while loop allows you to take all the messages that are
   'waiting in the message queue.
   '
   Do While MIDIInput1.MessageCount > 0
      '
      'This is the incoming MIDI data
      '
      InMessage = MIDIInput1.message
      InData1 = MIDIInput1.data1
      InData2 = MIDIInput1.data2
      


' If this is a note on or note off
' event, transpose it according to the
' value of VSliderTranspose control.
      
      If InMessage >= 128 And InMessage <= 159 Then
         InData1 = InData1 + vslidertranspose
      End If

' check for reversed keyboard

    If reversemode = True Then
        InData1 = 127 - InData1
    End If
    
' change the mod wheel controller messages into note
' on messages with the wheel setting as velocity
'
    If InMessage = CONTROLLER_CHANGE Then
        If InData1 = MOD_WHEEL Then
            InMessage = NOTE_ON
            InData1 = wheelnote.Value
        End If
    End If
    
    
            

  
'
'Tell MIDIOutput1 to send the MIDI data
'

         MIDIOutput1.message = InMessage
         MIDIOutput1.data1 = InData1
         MIDIOutput1.data2 = InData2
         MIDIOutput1.Action = MIDIOUT_SEND
 

   
      '
      'Remove the MIDI data from the MIDI IN queue
      '
      MIDIInput1.Action = MIDIIN_REMOVE
      
'
' display the data in text boxes
'
    message.Text = InMessage
    data1.Text = InData1
    data2.Text = InData2
    
    
   Loop
End Sub

Private Sub reverse_Click()

If reversemode = True Then
    reversemode = False
Else
    reversemode = True
End If

End Sub

Private Sub stopbutton_Click()
    Call mnuFileExit_Click
    
End Sub
